<?php
/**
 * ReconEntityDataInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2023-08-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * ReconEntityDataInner Class Doc Comment
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReconEntityDataInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReconEntity_data_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'event_id' => 'string',
        'event_type' => 'string',
        'event_settlement_amount' => 'float',
        'event_amount' => 'float',
        'sale_type' => 'string',
        'event_status' => 'string',
        'entity' => 'string',
        'event_time' => 'string',
        'event_currency' => 'string',
        'order_id' => 'string',
        'order_amount' => 'float',
        'customer_phone' => 'string',
        'customer_email' => 'string',
        'customer_name' => 'string',
        'payment_amount' => 'float',
        'payment_utr' => 'string',
        'payment_time' => 'string',
        'payment_service_charge' => 'float',
        'payment_service_tax' => 'float',
        'cf_payment_id' => 'string',
        'cf_settlement_id' => 'string',
        'settlement_date' => 'string',
        'settlement_utr' => 'string',
        'split_service_charge' => 'float',
        'split_service_tax' => 'float',
        'vendor_commission' => 'float',
        'closed_in_favor_of' => 'string',
        'dispute_resolved_on' => 'string',
        'dispute_category' => 'string',
        'dispute_note' => 'string',
        'refund_processed_at' => 'string',
        'refund_arn' => 'string',
        'refund_note' => 'string',
        'refund_id' => 'string',
        'adjustment_remarks' => 'string',
        'adjustment' => 'float',
        'service_tax' => 'float',
        'service_charge' => 'float',
        'amount_settled' => 'float',
        'payment_from' => 'string',
        'payment_till' => 'string',
        'reason' => 'string',
        'settlement_initiated_on' => 'string',
        'settlement_type' => 'string',
        'settlement_charge' => 'float',
        'settlement_tax' => 'float',
        'remarks' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'event_id' => null,
        'event_type' => null,
        'event_settlement_amount' => null,
        'event_amount' => null,
        'sale_type' => null,
        'event_status' => null,
        'entity' => null,
        'event_time' => null,
        'event_currency' => null,
        'order_id' => null,
        'order_amount' => null,
        'customer_phone' => null,
        'customer_email' => null,
        'customer_name' => null,
        'payment_amount' => null,
        'payment_utr' => null,
        'payment_time' => null,
        'payment_service_charge' => null,
        'payment_service_tax' => null,
        'cf_payment_id' => null,
        'cf_settlement_id' => null,
        'settlement_date' => null,
        'settlement_utr' => null,
        'split_service_charge' => null,
        'split_service_tax' => null,
        'vendor_commission' => null,
        'closed_in_favor_of' => null,
        'dispute_resolved_on' => null,
        'dispute_category' => null,
        'dispute_note' => null,
        'refund_processed_at' => null,
        'refund_arn' => null,
        'refund_note' => null,
        'refund_id' => null,
        'adjustment_remarks' => null,
        'adjustment' => null,
        'service_tax' => null,
        'service_charge' => null,
        'amount_settled' => null,
        'payment_from' => null,
        'payment_till' => null,
        'reason' => null,
        'settlement_initiated_on' => null,
        'settlement_type' => null,
        'settlement_charge' => null,
        'settlement_tax' => null,
        'remarks' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'event_id' => false,
		'event_type' => false,
		'event_settlement_amount' => false,
		'event_amount' => false,
		'sale_type' => false,
		'event_status' => false,
		'entity' => false,
		'event_time' => false,
		'event_currency' => false,
		'order_id' => false,
		'order_amount' => false,
		'customer_phone' => false,
		'customer_email' => false,
		'customer_name' => false,
		'payment_amount' => false,
		'payment_utr' => false,
		'payment_time' => false,
		'payment_service_charge' => false,
		'payment_service_tax' => false,
		'cf_payment_id' => false,
		'cf_settlement_id' => false,
		'settlement_date' => false,
		'settlement_utr' => false,
		'split_service_charge' => false,
		'split_service_tax' => false,
		'vendor_commission' => false,
		'closed_in_favor_of' => false,
		'dispute_resolved_on' => false,
		'dispute_category' => false,
		'dispute_note' => false,
		'refund_processed_at' => false,
		'refund_arn' => false,
		'refund_note' => false,
		'refund_id' => false,
		'adjustment_remarks' => false,
		'adjustment' => false,
		'service_tax' => false,
		'service_charge' => false,
		'amount_settled' => false,
		'payment_from' => false,
		'payment_till' => false,
		'reason' => false,
		'settlement_initiated_on' => false,
		'settlement_type' => false,
		'settlement_charge' => false,
		'settlement_tax' => false,
		'remarks' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'event_id' => 'event_id',
        'event_type' => 'event_type',
        'event_settlement_amount' => 'event_settlement_amount',
        'event_amount' => 'event_amount',
        'sale_type' => 'sale_type',
        'event_status' => 'event_status',
        'entity' => 'entity',
        'event_time' => 'event_time',
        'event_currency' => 'event_currency',
        'order_id' => 'order_id',
        'order_amount' => 'order_amount',
        'customer_phone' => 'customer_phone',
        'customer_email' => 'customer_email',
        'customer_name' => 'customer_name',
        'payment_amount' => 'payment_amount',
        'payment_utr' => 'payment_utr',
        'payment_time' => 'payment_time',
        'payment_service_charge' => 'payment_service_charge',
        'payment_service_tax' => 'payment_service_tax',
        'cf_payment_id' => 'cf_payment_id',
        'cf_settlement_id' => 'cf_settlement_id',
        'settlement_date' => 'settlement_date',
        'settlement_utr' => 'settlement_utr',
        'split_service_charge' => 'split_service_charge',
        'split_service_tax' => 'split_service_tax',
        'vendor_commission' => 'vendor_commission',
        'closed_in_favor_of' => 'closed_in_favor_of',
        'dispute_resolved_on' => 'dispute_resolved_on',
        'dispute_category' => 'dispute_category',
        'dispute_note' => 'dispute_note',
        'refund_processed_at' => 'refund_processed_at',
        'refund_arn' => 'refund_arn',
        'refund_note' => 'refund_note',
        'refund_id' => 'refund_id',
        'adjustment_remarks' => 'adjustment_remarks',
        'adjustment' => 'adjustment',
        'service_tax' => 'service_tax',
        'service_charge' => 'service_charge',
        'amount_settled' => 'amount_settled',
        'payment_from' => 'payment_from',
        'payment_till' => 'payment_till',
        'reason' => 'reason',
        'settlement_initiated_on' => 'settlement_initiated_on',
        'settlement_type' => 'settlement_type',
        'settlement_charge' => 'settlement_charge',
        'settlement_tax' => 'settlement_tax',
        'remarks' => 'remarks'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'event_id' => 'setEventId',
        'event_type' => 'setEventType',
        'event_settlement_amount' => 'setEventSettlementAmount',
        'event_amount' => 'setEventAmount',
        'sale_type' => 'setSaleType',
        'event_status' => 'setEventStatus',
        'entity' => 'setEntity',
        'event_time' => 'setEventTime',
        'event_currency' => 'setEventCurrency',
        'order_id' => 'setOrderId',
        'order_amount' => 'setOrderAmount',
        'customer_phone' => 'setCustomerPhone',
        'customer_email' => 'setCustomerEmail',
        'customer_name' => 'setCustomerName',
        'payment_amount' => 'setPaymentAmount',
        'payment_utr' => 'setPaymentUtr',
        'payment_time' => 'setPaymentTime',
        'payment_service_charge' => 'setPaymentServiceCharge',
        'payment_service_tax' => 'setPaymentServiceTax',
        'cf_payment_id' => 'setCfPaymentId',
        'cf_settlement_id' => 'setCfSettlementId',
        'settlement_date' => 'setSettlementDate',
        'settlement_utr' => 'setSettlementUtr',
        'split_service_charge' => 'setSplitServiceCharge',
        'split_service_tax' => 'setSplitServiceTax',
        'vendor_commission' => 'setVendorCommission',
        'closed_in_favor_of' => 'setClosedInFavorOf',
        'dispute_resolved_on' => 'setDisputeResolvedOn',
        'dispute_category' => 'setDisputeCategory',
        'dispute_note' => 'setDisputeNote',
        'refund_processed_at' => 'setRefundProcessedAt',
        'refund_arn' => 'setRefundArn',
        'refund_note' => 'setRefundNote',
        'refund_id' => 'setRefundId',
        'adjustment_remarks' => 'setAdjustmentRemarks',
        'adjustment' => 'setAdjustment',
        'service_tax' => 'setServiceTax',
        'service_charge' => 'setServiceCharge',
        'amount_settled' => 'setAmountSettled',
        'payment_from' => 'setPaymentFrom',
        'payment_till' => 'setPaymentTill',
        'reason' => 'setReason',
        'settlement_initiated_on' => 'setSettlementInitiatedOn',
        'settlement_type' => 'setSettlementType',
        'settlement_charge' => 'setSettlementCharge',
        'settlement_tax' => 'setSettlementTax',
        'remarks' => 'setRemarks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'event_id' => 'getEventId',
        'event_type' => 'getEventType',
        'event_settlement_amount' => 'getEventSettlementAmount',
        'event_amount' => 'getEventAmount',
        'sale_type' => 'getSaleType',
        'event_status' => 'getEventStatus',
        'entity' => 'getEntity',
        'event_time' => 'getEventTime',
        'event_currency' => 'getEventCurrency',
        'order_id' => 'getOrderId',
        'order_amount' => 'getOrderAmount',
        'customer_phone' => 'getCustomerPhone',
        'customer_email' => 'getCustomerEmail',
        'customer_name' => 'getCustomerName',
        'payment_amount' => 'getPaymentAmount',
        'payment_utr' => 'getPaymentUtr',
        'payment_time' => 'getPaymentTime',
        'payment_service_charge' => 'getPaymentServiceCharge',
        'payment_service_tax' => 'getPaymentServiceTax',
        'cf_payment_id' => 'getCfPaymentId',
        'cf_settlement_id' => 'getCfSettlementId',
        'settlement_date' => 'getSettlementDate',
        'settlement_utr' => 'getSettlementUtr',
        'split_service_charge' => 'getSplitServiceCharge',
        'split_service_tax' => 'getSplitServiceTax',
        'vendor_commission' => 'getVendorCommission',
        'closed_in_favor_of' => 'getClosedInFavorOf',
        'dispute_resolved_on' => 'getDisputeResolvedOn',
        'dispute_category' => 'getDisputeCategory',
        'dispute_note' => 'getDisputeNote',
        'refund_processed_at' => 'getRefundProcessedAt',
        'refund_arn' => 'getRefundArn',
        'refund_note' => 'getRefundNote',
        'refund_id' => 'getRefundId',
        'adjustment_remarks' => 'getAdjustmentRemarks',
        'adjustment' => 'getAdjustment',
        'service_tax' => 'getServiceTax',
        'service_charge' => 'getServiceCharge',
        'amount_settled' => 'getAmountSettled',
        'payment_from' => 'getPaymentFrom',
        'payment_till' => 'getPaymentTill',
        'reason' => 'getReason',
        'settlement_initiated_on' => 'getSettlementInitiatedOn',
        'settlement_type' => 'getSettlementType',
        'settlement_charge' => 'getSettlementCharge',
        'settlement_tax' => 'getSettlementTax',
        'remarks' => 'getRemarks'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('event_id', $data ?? [], null);
        $this->setIfExists('event_type', $data ?? [], null);
        $this->setIfExists('event_settlement_amount', $data ?? [], null);
        $this->setIfExists('event_amount', $data ?? [], null);
        $this->setIfExists('sale_type', $data ?? [], null);
        $this->setIfExists('event_status', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('event_time', $data ?? [], null);
        $this->setIfExists('event_currency', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('order_amount', $data ?? [], null);
        $this->setIfExists('customer_phone', $data ?? [], null);
        $this->setIfExists('customer_email', $data ?? [], null);
        $this->setIfExists('customer_name', $data ?? [], null);
        $this->setIfExists('payment_amount', $data ?? [], null);
        $this->setIfExists('payment_utr', $data ?? [], null);
        $this->setIfExists('payment_time', $data ?? [], null);
        $this->setIfExists('payment_service_charge', $data ?? [], null);
        $this->setIfExists('payment_service_tax', $data ?? [], null);
        $this->setIfExists('cf_payment_id', $data ?? [], null);
        $this->setIfExists('cf_settlement_id', $data ?? [], null);
        $this->setIfExists('settlement_date', $data ?? [], null);
        $this->setIfExists('settlement_utr', $data ?? [], null);
        $this->setIfExists('split_service_charge', $data ?? [], null);
        $this->setIfExists('split_service_tax', $data ?? [], null);
        $this->setIfExists('vendor_commission', $data ?? [], null);
        $this->setIfExists('closed_in_favor_of', $data ?? [], null);
        $this->setIfExists('dispute_resolved_on', $data ?? [], null);
        $this->setIfExists('dispute_category', $data ?? [], null);
        $this->setIfExists('dispute_note', $data ?? [], null);
        $this->setIfExists('refund_processed_at', $data ?? [], null);
        $this->setIfExists('refund_arn', $data ?? [], null);
        $this->setIfExists('refund_note', $data ?? [], null);
        $this->setIfExists('refund_id', $data ?? [], null);
        $this->setIfExists('adjustment_remarks', $data ?? [], null);
        $this->setIfExists('adjustment', $data ?? [], null);
        $this->setIfExists('service_tax', $data ?? [], null);
        $this->setIfExists('service_charge', $data ?? [], null);
        $this->setIfExists('amount_settled', $data ?? [], null);
        $this->setIfExists('payment_from', $data ?? [], null);
        $this->setIfExists('payment_till', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('settlement_initiated_on', $data ?? [], null);
        $this->setIfExists('settlement_type', $data ?? [], null);
        $this->setIfExists('settlement_charge', $data ?? [], null);
        $this->setIfExists('settlement_tax', $data ?? [], null);
        $this->setIfExists('remarks', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets event_id
     *
     * @return string|null
     */
    public function getEventId()
    {
        return $this->container['event_id'];
    }

    /**
     * Sets event_id
     *
     * @param string|null $event_id Unique ID associated with the event.
     *
     * @return self
     */
    public function setEventId($event_id)
    {
        if (is_null($event_id)) {
            throw new \InvalidArgumentException('non-nullable event_id cannot be null');
        }
        $this->container['event_id'] = $event_id;

        return $this;
    }

    /**
     * Gets event_type
     *
     * @return string|null
     */
    public function getEventType()
    {
        return $this->container['event_type'];
    }

    /**
     * Sets event_type
     *
     * @param string|null $event_type The event type can be SETTLEMENT, PAYMENT, REFUND, REFUND_REVERSAL, DISPUTE, DISPUTE_REVERSAL, CHARGEBACK, CHARGEBACK_REVERSAL, OTHER_ADJUSTMENT.
     *
     * @return self
     */
    public function setEventType($event_type)
    {
        if (is_null($event_type)) {
            throw new \InvalidArgumentException('non-nullable event_type cannot be null');
        }
        $this->container['event_type'] = $event_type;

        return $this;
    }

    /**
     * Gets event_settlement_amount
     *
     * @return float|null
     */
    public function getEventSettlementAmount()
    {
        return $this->container['event_settlement_amount'];
    }

    /**
     * Sets event_settlement_amount
     *
     * @param float|null $event_settlement_amount Amount that is part of the settlement corresponding to the event.
     *
     * @return self
     */
    public function setEventSettlementAmount($event_settlement_amount)
    {
        if (is_null($event_settlement_amount)) {
            throw new \InvalidArgumentException('non-nullable event_settlement_amount cannot be null');
        }
        $this->container['event_settlement_amount'] = $event_settlement_amount;

        return $this;
    }

    /**
     * Gets event_amount
     *
     * @return float|null
     */
    public function getEventAmount()
    {
        return $this->container['event_amount'];
    }

    /**
     * Sets event_amount
     *
     * @param float|null $event_amount Amount of the event. Example, refund amount, dispute amount, payment amount, etc.
     *
     * @return self
     */
    public function setEventAmount($event_amount)
    {
        if (is_null($event_amount)) {
            throw new \InvalidArgumentException('non-nullable event_amount cannot be null');
        }
        $this->container['event_amount'] = $event_amount;

        return $this;
    }

    /**
     * Gets sale_type
     *
     * @return string|null
     */
    public function getSaleType()
    {
        return $this->container['sale_type'];
    }

    /**
     * Sets sale_type
     *
     * @param string|null $sale_type Indicates if it is CREDIT/DEBIT sale.
     *
     * @return self
     */
    public function setSaleType($sale_type)
    {
        if (is_null($sale_type)) {
            throw new \InvalidArgumentException('non-nullable sale_type cannot be null');
        }
        $this->container['sale_type'] = $sale_type;

        return $this;
    }

    /**
     * Gets event_status
     *
     * @return string|null
     */
    public function getEventStatus()
    {
        return $this->container['event_status'];
    }

    /**
     * Sets event_status
     *
     * @param string|null $event_status Status of the event. Example - SUCCESS, FAILED, PENDING, CANCELLED.
     *
     * @return self
     */
    public function setEventStatus($event_status)
    {
        if (is_null($event_status)) {
            throw new \InvalidArgumentException('non-nullable event_status cannot be null');
        }
        $this->container['event_status'] = $event_status;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return string|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param string|null $entity Recon
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets event_time
     *
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->container['event_time'];
    }

    /**
     * Sets event_time
     *
     * @param string|null $event_time Time associated with the event. Example, transaction time, dispute initiation time
     *
     * @return self
     */
    public function setEventTime($event_time)
    {
        if (is_null($event_time)) {
            throw new \InvalidArgumentException('non-nullable event_time cannot be null');
        }
        $this->container['event_time'] = $event_time;

        return $this;
    }

    /**
     * Gets event_currency
     *
     * @return string|null
     */
    public function getEventCurrency()
    {
        return $this->container['event_currency'];
    }

    /**
     * Sets event_currency
     *
     * @param string|null $event_currency Curreny type - INR.
     *
     * @return self
     */
    public function setEventCurrency($event_currency)
    {
        if (is_null($event_currency)) {
            throw new \InvalidArgumentException('non-nullable event_currency cannot be null');
        }
        $this->container['event_currency'] = $event_currency;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Unique order ID. Alphanumeric and only '-' and '_' allowed.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets order_amount
     *
     * @return float|null
     */
    public function getOrderAmount()
    {
        return $this->container['order_amount'];
    }

    /**
     * Sets order_amount
     *
     * @param float|null $order_amount The amount which was passed at the order creation time.
     *
     * @return self
     */
    public function setOrderAmount($order_amount)
    {
        if (is_null($order_amount)) {
            throw new \InvalidArgumentException('non-nullable order_amount cannot be null');
        }
        $this->container['order_amount'] = $order_amount;

        return $this;
    }

    /**
     * Gets customer_phone
     *
     * @return string|null
     */
    public function getCustomerPhone()
    {
        return $this->container['customer_phone'];
    }

    /**
     * Sets customer_phone
     *
     * @param string|null $customer_phone Customer phone number.
     *
     * @return self
     */
    public function setCustomerPhone($customer_phone)
    {
        if (is_null($customer_phone)) {
            throw new \InvalidArgumentException('non-nullable customer_phone cannot be null');
        }
        $this->container['customer_phone'] = $customer_phone;

        return $this;
    }

    /**
     * Gets customer_email
     *
     * @return string|null
     */
    public function getCustomerEmail()
    {
        return $this->container['customer_email'];
    }

    /**
     * Sets customer_email
     *
     * @param string|null $customer_email Customer email.
     *
     * @return self
     */
    public function setCustomerEmail($customer_email)
    {
        if (is_null($customer_email)) {
            throw new \InvalidArgumentException('non-nullable customer_email cannot be null');
        }
        $this->container['customer_email'] = $customer_email;

        return $this;
    }

    /**
     * Gets customer_name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->container['customer_name'];
    }

    /**
     * Sets customer_name
     *
     * @param string|null $customer_name Customer name.
     *
     * @return self
     */
    public function setCustomerName($customer_name)
    {
        if (is_null($customer_name)) {
            throw new \InvalidArgumentException('non-nullable customer_name cannot be null');
        }
        $this->container['customer_name'] = $customer_name;

        return $this;
    }

    /**
     * Gets payment_amount
     *
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->container['payment_amount'];
    }

    /**
     * Sets payment_amount
     *
     * @param float|null $payment_amount Payment amount captured.
     *
     * @return self
     */
    public function setPaymentAmount($payment_amount)
    {
        if (is_null($payment_amount)) {
            throw new \InvalidArgumentException('non-nullable payment_amount cannot be null');
        }
        $this->container['payment_amount'] = $payment_amount;

        return $this;
    }

    /**
     * Gets payment_utr
     *
     * @return string|null
     */
    public function getPaymentUtr()
    {
        return $this->container['payment_utr'];
    }

    /**
     * Sets payment_utr
     *
     * @param string|null $payment_utr Unique transaction reference number of the payment.
     *
     * @return self
     */
    public function setPaymentUtr($payment_utr)
    {
        if (is_null($payment_utr)) {
            throw new \InvalidArgumentException('non-nullable payment_utr cannot be null');
        }
        $this->container['payment_utr'] = $payment_utr;

        return $this;
    }

    /**
     * Gets payment_time
     *
     * @return string|null
     */
    public function getPaymentTime()
    {
        return $this->container['payment_time'];
    }

    /**
     * Sets payment_time
     *
     * @param string|null $payment_time Date and time when the payment was initiated.
     *
     * @return self
     */
    public function setPaymentTime($payment_time)
    {
        if (is_null($payment_time)) {
            throw new \InvalidArgumentException('non-nullable payment_time cannot be null');
        }
        $this->container['payment_time'] = $payment_time;

        return $this;
    }

    /**
     * Gets payment_service_charge
     *
     * @return float|null
     */
    public function getPaymentServiceCharge()
    {
        return $this->container['payment_service_charge'];
    }

    /**
     * Sets payment_service_charge
     *
     * @param float|null $payment_service_charge Service charge applicable for the payment.
     *
     * @return self
     */
    public function setPaymentServiceCharge($payment_service_charge)
    {
        if (is_null($payment_service_charge)) {
            throw new \InvalidArgumentException('non-nullable payment_service_charge cannot be null');
        }
        $this->container['payment_service_charge'] = $payment_service_charge;

        return $this;
    }

    /**
     * Gets payment_service_tax
     *
     * @return float|null
     */
    public function getPaymentServiceTax()
    {
        return $this->container['payment_service_tax'];
    }

    /**
     * Sets payment_service_tax
     *
     * @param float|null $payment_service_tax Service tax applicable on the payment.
     *
     * @return self
     */
    public function setPaymentServiceTax($payment_service_tax)
    {
        if (is_null($payment_service_tax)) {
            throw new \InvalidArgumentException('non-nullable payment_service_tax cannot be null');
        }
        $this->container['payment_service_tax'] = $payment_service_tax;

        return $this;
    }

    /**
     * Gets cf_payment_id
     *
     * @return string|null
     */
    public function getCfPaymentId()
    {
        return $this->container['cf_payment_id'];
    }

    /**
     * Sets cf_payment_id
     *
     * @param string|null $cf_payment_id Cashfree Payments unique ID to identify a payment.
     *
     * @return self
     */
    public function setCfPaymentId($cf_payment_id)
    {
        if (is_null($cf_payment_id)) {
            throw new \InvalidArgumentException('non-nullable cf_payment_id cannot be null');
        }
        $this->container['cf_payment_id'] = $cf_payment_id;

        return $this;
    }

    /**
     * Gets cf_settlement_id
     *
     * @return string|null
     */
    public function getCfSettlementId()
    {
        return $this->container['cf_settlement_id'];
    }

    /**
     * Sets cf_settlement_id
     *
     * @param string|null $cf_settlement_id Unique ID to identify the settlement.
     *
     * @return self
     */
    public function setCfSettlementId($cf_settlement_id)
    {
        if (is_null($cf_settlement_id)) {
            throw new \InvalidArgumentException('non-nullable cf_settlement_id cannot be null');
        }
        $this->container['cf_settlement_id'] = $cf_settlement_id;

        return $this;
    }

    /**
     * Gets settlement_date
     *
     * @return string|null
     */
    public function getSettlementDate()
    {
        return $this->container['settlement_date'];
    }

    /**
     * Sets settlement_date
     *
     * @param string|null $settlement_date Date and time when the settlement was processed.
     *
     * @return self
     */
    public function setSettlementDate($settlement_date)
    {
        if (is_null($settlement_date)) {
            throw new \InvalidArgumentException('non-nullable settlement_date cannot be null');
        }
        $this->container['settlement_date'] = $settlement_date;

        return $this;
    }

    /**
     * Gets settlement_utr
     *
     * @return string|null
     */
    public function getSettlementUtr()
    {
        return $this->container['settlement_utr'];
    }

    /**
     * Sets settlement_utr
     *
     * @param string|null $settlement_utr Unique transaction reference number of the settlement.
     *
     * @return self
     */
    public function setSettlementUtr($settlement_utr)
    {
        if (is_null($settlement_utr)) {
            throw new \InvalidArgumentException('non-nullable settlement_utr cannot be null');
        }
        $this->container['settlement_utr'] = $settlement_utr;

        return $this;
    }

    /**
     * Gets split_service_charge
     *
     * @return float|null
     */
    public function getSplitServiceCharge()
    {
        return $this->container['split_service_charge'];
    }

    /**
     * Sets split_service_charge
     *
     * @param float|null $split_service_charge Service charge that is applicable for splitting the payment.
     *
     * @return self
     */
    public function setSplitServiceCharge($split_service_charge)
    {
        if (is_null($split_service_charge)) {
            throw new \InvalidArgumentException('non-nullable split_service_charge cannot be null');
        }
        $this->container['split_service_charge'] = $split_service_charge;

        return $this;
    }

    /**
     * Gets split_service_tax
     *
     * @return float|null
     */
    public function getSplitServiceTax()
    {
        return $this->container['split_service_tax'];
    }

    /**
     * Sets split_service_tax
     *
     * @param float|null $split_service_tax Service tax applicable for splitting the amount to vendors.
     *
     * @return self
     */
    public function setSplitServiceTax($split_service_tax)
    {
        if (is_null($split_service_tax)) {
            throw new \InvalidArgumentException('non-nullable split_service_tax cannot be null');
        }
        $this->container['split_service_tax'] = $split_service_tax;

        return $this;
    }

    /**
     * Gets vendor_commission
     *
     * @return float|null
     */
    public function getVendorCommission()
    {
        return $this->container['vendor_commission'];
    }

    /**
     * Sets vendor_commission
     *
     * @param float|null $vendor_commission Vendor commission applicable for this transaction.
     *
     * @return self
     */
    public function setVendorCommission($vendor_commission)
    {
        if (is_null($vendor_commission)) {
            throw new \InvalidArgumentException('non-nullable vendor_commission cannot be null');
        }
        $this->container['vendor_commission'] = $vendor_commission;

        return $this;
    }

    /**
     * Gets closed_in_favor_of
     *
     * @return string|null
     */
    public function getClosedInFavorOf()
    {
        return $this->container['closed_in_favor_of'];
    }

    /**
     * Sets closed_in_favor_of
     *
     * @param string|null $closed_in_favor_of Specifies whether the dispute was closed in favor of the merchant or customer. /n Possible values - Merchant, Customer
     *
     * @return self
     */
    public function setClosedInFavorOf($closed_in_favor_of)
    {
        if (is_null($closed_in_favor_of)) {
            throw new \InvalidArgumentException('non-nullable closed_in_favor_of cannot be null');
        }
        $this->container['closed_in_favor_of'] = $closed_in_favor_of;

        return $this;
    }

    /**
     * Gets dispute_resolved_on
     *
     * @return string|null
     */
    public function getDisputeResolvedOn()
    {
        return $this->container['dispute_resolved_on'];
    }

    /**
     * Sets dispute_resolved_on
     *
     * @param string|null $dispute_resolved_on Date and time when the dispute was resolved.
     *
     * @return self
     */
    public function setDisputeResolvedOn($dispute_resolved_on)
    {
        if (is_null($dispute_resolved_on)) {
            throw new \InvalidArgumentException('non-nullable dispute_resolved_on cannot be null');
        }
        $this->container['dispute_resolved_on'] = $dispute_resolved_on;

        return $this;
    }

    /**
     * Gets dispute_category
     *
     * @return string|null
     */
    public function getDisputeCategory()
    {
        return $this->container['dispute_category'];
    }

    /**
     * Sets dispute_category
     *
     * @param string|null $dispute_category Category of the dispute - Dispute code and the reason for dispute is shown.
     *
     * @return self
     */
    public function setDisputeCategory($dispute_category)
    {
        if (is_null($dispute_category)) {
            throw new \InvalidArgumentException('non-nullable dispute_category cannot be null');
        }
        $this->container['dispute_category'] = $dispute_category;

        return $this;
    }

    /**
     * Gets dispute_note
     *
     * @return string|null
     */
    public function getDisputeNote()
    {
        return $this->container['dispute_note'];
    }

    /**
     * Sets dispute_note
     *
     * @param string|null $dispute_note Note regarding the dispute.
     *
     * @return self
     */
    public function setDisputeNote($dispute_note)
    {
        if (is_null($dispute_note)) {
            throw new \InvalidArgumentException('non-nullable dispute_note cannot be null');
        }
        $this->container['dispute_note'] = $dispute_note;

        return $this;
    }

    /**
     * Gets refund_processed_at
     *
     * @return string|null
     */
    public function getRefundProcessedAt()
    {
        return $this->container['refund_processed_at'];
    }

    /**
     * Sets refund_processed_at
     *
     * @param string|null $refund_processed_at Date and time when the refund was processed.
     *
     * @return self
     */
    public function setRefundProcessedAt($refund_processed_at)
    {
        if (is_null($refund_processed_at)) {
            throw new \InvalidArgumentException('non-nullable refund_processed_at cannot be null');
        }
        $this->container['refund_processed_at'] = $refund_processed_at;

        return $this;
    }

    /**
     * Gets refund_arn
     *
     * @return string|null
     */
    public function getRefundArn()
    {
        return $this->container['refund_arn'];
    }

    /**
     * Sets refund_arn
     *
     * @param string|null $refund_arn The bank reference number for the refund.
     *
     * @return self
     */
    public function setRefundArn($refund_arn)
    {
        if (is_null($refund_arn)) {
            throw new \InvalidArgumentException('non-nullable refund_arn cannot be null');
        }
        $this->container['refund_arn'] = $refund_arn;

        return $this;
    }

    /**
     * Gets refund_note
     *
     * @return string|null
     */
    public function getRefundNote()
    {
        return $this->container['refund_note'];
    }

    /**
     * Sets refund_note
     *
     * @param string|null $refund_note A refund note for your reference.
     *
     * @return self
     */
    public function setRefundNote($refund_note)
    {
        if (is_null($refund_note)) {
            throw new \InvalidArgumentException('non-nullable refund_note cannot be null');
        }
        $this->container['refund_note'] = $refund_note;

        return $this;
    }

    /**
     * Gets refund_id
     *
     * @return string|null
     */
    public function getRefundId()
    {
        return $this->container['refund_id'];
    }

    /**
     * Sets refund_id
     *
     * @param string|null $refund_id An unique ID to associate the refund with.
     *
     * @return self
     */
    public function setRefundId($refund_id)
    {
        if (is_null($refund_id)) {
            throw new \InvalidArgumentException('non-nullable refund_id cannot be null');
        }
        $this->container['refund_id'] = $refund_id;

        return $this;
    }

    /**
     * Gets adjustment_remarks
     *
     * @return string|null
     */
    public function getAdjustmentRemarks()
    {
        return $this->container['adjustment_remarks'];
    }

    /**
     * Sets adjustment_remarks
     *
     * @param string|null $adjustment_remarks Other adjustment remarks.
     *
     * @return self
     */
    public function setAdjustmentRemarks($adjustment_remarks)
    {
        if (is_null($adjustment_remarks)) {
            throw new \InvalidArgumentException('non-nullable adjustment_remarks cannot be null');
        }
        $this->container['adjustment_remarks'] = $adjustment_remarks;

        return $this;
    }

    /**
     * Gets adjustment
     *
     * @return float|null
     */
    public function getAdjustment()
    {
        return $this->container['adjustment'];
    }

    /**
     * Sets adjustment
     *
     * @param float|null $adjustment Amount that is adjusted from the settlement amount because of any credit/debit event such as refund, refund_reverse etc.
     *
     * @return self
     */
    public function setAdjustment($adjustment)
    {
        if (is_null($adjustment)) {
            throw new \InvalidArgumentException('non-nullable adjustment cannot be null');
        }
        $this->container['adjustment'] = $adjustment;

        return $this;
    }

    /**
     * Gets service_tax
     *
     * @return float|null
     */
    public function getServiceTax()
    {
        return $this->container['service_tax'];
    }

    /**
     * Sets service_tax
     *
     * @param float|null $service_tax Service tax applicable on the settlement amount.
     *
     * @return self
     */
    public function setServiceTax($service_tax)
    {
        if (is_null($service_tax)) {
            throw new \InvalidArgumentException('non-nullable service_tax cannot be null');
        }
        $this->container['service_tax'] = $service_tax;

        return $this;
    }

    /**
     * Gets service_charge
     *
     * @return float|null
     */
    public function getServiceCharge()
    {
        return $this->container['service_charge'];
    }

    /**
     * Sets service_charge
     *
     * @param float|null $service_charge Service charge applicable on the settlement amount.
     *
     * @return self
     */
    public function setServiceCharge($service_charge)
    {
        if (is_null($service_charge)) {
            throw new \InvalidArgumentException('non-nullable service_charge cannot be null');
        }
        $this->container['service_charge'] = $service_charge;

        return $this;
    }

    /**
     * Gets amount_settled
     *
     * @return float|null
     */
    public function getAmountSettled()
    {
        return $this->container['amount_settled'];
    }

    /**
     * Sets amount_settled
     *
     * @param float|null $amount_settled Net amount that is settled after considering the adjustments, settlement charge and tax.
     *
     * @return self
     */
    public function setAmountSettled($amount_settled)
    {
        if (is_null($amount_settled)) {
            throw new \InvalidArgumentException('non-nullable amount_settled cannot be null');
        }
        $this->container['amount_settled'] = $amount_settled;

        return $this;
    }

    /**
     * Gets payment_from
     *
     * @return string|null
     */
    public function getPaymentFrom()
    {
        return $this->container['payment_from'];
    }

    /**
     * Sets payment_from
     *
     * @param string|null $payment_from The start time of the time range of the payments considered for the settlement.
     *
     * @return self
     */
    public function setPaymentFrom($payment_from)
    {
        if (is_null($payment_from)) {
            throw new \InvalidArgumentException('non-nullable payment_from cannot be null');
        }
        $this->container['payment_from'] = $payment_from;

        return $this;
    }

    /**
     * Gets payment_till
     *
     * @return string|null
     */
    public function getPaymentTill()
    {
        return $this->container['payment_till'];
    }

    /**
     * Sets payment_till
     *
     * @param string|null $payment_till The end time of time range of the payments considered for the settlement.
     *
     * @return self
     */
    public function setPaymentTill($payment_till)
    {
        if (is_null($payment_till)) {
            throw new \InvalidArgumentException('non-nullable payment_till cannot be null');
        }
        $this->container['payment_till'] = $payment_till;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason Reason for settlement failure.
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets settlement_initiated_on
     *
     * @return string|null
     */
    public function getSettlementInitiatedOn()
    {
        return $this->container['settlement_initiated_on'];
    }

    /**
     * Sets settlement_initiated_on
     *
     * @param string|null $settlement_initiated_on Date and time when the settlement was initiated.
     *
     * @return self
     */
    public function setSettlementInitiatedOn($settlement_initiated_on)
    {
        if (is_null($settlement_initiated_on)) {
            throw new \InvalidArgumentException('non-nullable settlement_initiated_on cannot be null');
        }
        $this->container['settlement_initiated_on'] = $settlement_initiated_on;

        return $this;
    }

    /**
     * Gets settlement_type
     *
     * @return string|null
     */
    public function getSettlementType()
    {
        return $this->container['settlement_type'];
    }

    /**
     * Sets settlement_type
     *
     * @param string|null $settlement_type Type of settlement. Possible values - Standard, Instant, On demand.
     *
     * @return self
     */
    public function setSettlementType($settlement_type)
    {
        if (is_null($settlement_type)) {
            throw new \InvalidArgumentException('non-nullable settlement_type cannot be null');
        }
        $this->container['settlement_type'] = $settlement_type;

        return $this;
    }

    /**
     * Gets settlement_charge
     *
     * @return float|null
     */
    public function getSettlementCharge()
    {
        return $this->container['settlement_charge'];
    }

    /**
     * Sets settlement_charge
     *
     * @param float|null $settlement_charge Settlement charges applicable on the settlement.
     *
     * @return self
     */
    public function setSettlementCharge($settlement_charge)
    {
        if (is_null($settlement_charge)) {
            throw new \InvalidArgumentException('non-nullable settlement_charge cannot be null');
        }
        $this->container['settlement_charge'] = $settlement_charge;

        return $this;
    }

    /**
     * Gets settlement_tax
     *
     * @return float|null
     */
    public function getSettlementTax()
    {
        return $this->container['settlement_tax'];
    }

    /**
     * Sets settlement_tax
     *
     * @param float|null $settlement_tax Settlement tax applicable on the settlement.
     *
     * @return self
     */
    public function setSettlementTax($settlement_tax)
    {
        if (is_null($settlement_tax)) {
            throw new \InvalidArgumentException('non-nullable settlement_tax cannot be null');
        }
        $this->container['settlement_tax'] = $settlement_tax;

        return $this;
    }

    /**
     * Gets remarks
     *
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->container['remarks'];
    }

    /**
     * Sets remarks
     *
     * @param string|null $remarks Remarks on the settlement.
     *
     * @return self
     */
    public function setRemarks($remarks)
    {
        if (is_null($remarks)) {
            throw new \InvalidArgumentException('non-nullable remarks cannot be null');
        }
        $this->container['remarks'] = $remarks;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


