<?php

namespace Database\Seeders;


use Dipokhalder\EnvEditor\EnvEditor;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use Smartisan\Settings\Facades\Settings;

class CompanyTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::group('company')->set([
            'company_name'         => 'Teqbasket - Restaurant Food Ordering & Delivery App',
            'company_email'        => 'info@Teqbasket.net',
            'company_phone'        => '+16479693767',
            'company_website'      => 'https://Teqbasket.dev',
            'company_city'         => 'Markham',
            'company_state'        => 'Ontario',
            'company_country_code' => 'CAD',
            'company_zip_code'     => 'L6B 0E1',
            'company_address'      => '19 Round Hill Court'
        ]);

        $envService = new EnvEditor();
        $envService->addData([
            'APP_NAME' => "Teqbasket - Restaurant Food Ordering & Delivery App"
        ]);
        Artisan::call('optimize:clear');
    }
}
